#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

//This namespace holds Indicators in this folder and is required. Do not change it. 
namespace NinjaTrader.NinjaScript.Indicators.Porschay
{
	public class PriscillianManipulatorX1 : Indicator
	{
		private ATR atr;
		public Series<double> lineColor;
		
		protected override void OnStateChange()
		{
			if (State == State.SetDefaults)
			{
				Description									= @"Enter the description for your new custom Indicator here.";
				Name										= "Priscillian - Manipulator X1";
				Calculate									= Calculate.OnBarClose;
				IsOverlay									= true;
				DisplayInDataBox							= true;
				DrawOnPricePanel							= true;
				DrawHorizontalGridLines						= true;
				DrawVerticalGridLines						= true;
				PaintPriceMarkers							= true;
				ScaleJustification							= NinjaTrader.Gui.Chart.ScaleJustification.Right;
				//Disable this property if your indicator requires custom values that cumulate with each new market data event. 
				//See Help Guide for additional information.
				IsSuspendedWhileInactive					= true;
				
				Period					= 12;
				Multiplier					= 3;
				
				BullBrush						= Brushes.Lime;
				BearBrush						= Brushes.Red;
				
				AddPlot(Brushes.Orange, "TrailingStop");
			}
			else if (State == State.Configure)
			{
			}
			else if (State == State.DataLoaded)
			{
				lineColor = new Series<double>(this);
				atr = ATR(Period);
			}
		}

		protected override void OnBarUpdate()
		{
			if (CurrentBar < Period)
				return;
			
			double stop = atr[0] * Multiplier;
			double value = 0;
			
			if (Close[0] > TrailingStop[1] && Close[1] > TrailingStop[1]) {
				value = Math.Max(TrailingStop[1], Close[0] - stop);
			} else if (Close[0] < TrailingStop[1] && Close[1] < TrailingStop[1])
			    value = Math.Min(TrailingStop[1], Close[0] + stop);
			else if (Close[0] > TrailingStop[1])
			    value = Close[0] - stop; 
			else 
			    value = Close[0] + stop;
			
			TrailingStop[0] = value;
			
			
			double position = 0;
			if (Close[1] < TrailingStop[1] && Close[0] > TrailingStop[1])
			    position = 1;
			else if (Close[1] > TrailingStop[1] && Close[0] < TrailingStop[1])
			    position = -1;
			else
			    position = lineColor[1];
			
			lineColor[0] = position;
			
			PlotBrushes[0][0] = lineColor[0] == 1 ? BullBrush : BearBrush;	
		}

		#region Properties
		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Period", Order=1, GroupName="Parameters")]
		public int Period
		{ get; set; }

		[NinjaScriptProperty]
		[Range(1, int.MaxValue)]
		[Display(Name="Multiplier", Order=2, GroupName="Parameters")]
		public int Multiplier
		{ get; set; }
		
		[XmlIgnore()]
		[Display(Name = "Bull Color", GroupName="Colors", Order=1)]
		public Brush BullBrush
		{ get; set; }

		[Browsable(false)]
		public string BullBrushSerialize
		{
			get { return Serialize.BrushToString(BullBrush); }
   			set { BullBrush = Serialize.StringToBrush(value); }
		}
		
		[XmlIgnore()]
		[Display(Name = "Bear Color", GroupName="Colors", Order=2)]
		public Brush BearBrush
		{ get; set; }

		[Browsable(false)]
		public string BearBrushSerialize
		{
			get { return Serialize.BrushToString(BearBrush); }
   			set { BearBrush = Serialize.StringToBrush(value); }
		}

		[Browsable(false)]
		[XmlIgnore]
		public Series<double> TrailingStop
		{
			get { return Values[0]; }
		}
		#endregion

	}
}

#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		private Porschay.PriscillianManipulatorX1[] cachePriscillianManipulatorX1;
		public Porschay.PriscillianManipulatorX1 PriscillianManipulatorX1(int period, int multiplier)
		{
			return PriscillianManipulatorX1(Input, period, multiplier);
		}

		public Porschay.PriscillianManipulatorX1 PriscillianManipulatorX1(ISeries<double> input, int period, int multiplier)
		{
			if (cachePriscillianManipulatorX1 != null)
				for (int idx = 0; idx < cachePriscillianManipulatorX1.Length; idx++)
					if (cachePriscillianManipulatorX1[idx] != null && cachePriscillianManipulatorX1[idx].Period == period && cachePriscillianManipulatorX1[idx].Multiplier == multiplier && cachePriscillianManipulatorX1[idx].EqualsInput(input))
						return cachePriscillianManipulatorX1[idx];
			return CacheIndicator<Porschay.PriscillianManipulatorX1>(new Porschay.PriscillianManipulatorX1(){ Period = period, Multiplier = multiplier }, input, ref cachePriscillianManipulatorX1);
		}
	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		public Indicators.Porschay.PriscillianManipulatorX1 PriscillianManipulatorX1(int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1(Input, period, multiplier);
		}

		public Indicators.Porschay.PriscillianManipulatorX1 PriscillianManipulatorX1(ISeries<double> input , int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1(input, period, multiplier);
		}
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		public Indicators.Porschay.PriscillianManipulatorX1 PriscillianManipulatorX1(int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1(Input, period, multiplier);
		}

		public Indicators.Porschay.PriscillianManipulatorX1 PriscillianManipulatorX1(ISeries<double> input , int period, int multiplier)
		{
			return indicator.PriscillianManipulatorX1(input, period, multiplier);
		}
	}
}

#endregion
